<?php
/* --------------------------------------------------------------
   OrderShippingOptionsRepository.inc.php 2021-08-10
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/
declare(strict_types=1);

class OrderShippingOptionsRepository
{
    /**
     * @var CI_DB_query_builder
     */
    private $db;
    
    
    public function __construct()
    {
        /** @var CI_DB_query_builder db */
        $this->db = StaticGXCoreLoader::getDatabaseQueryBuilder();
    }
    
    
    public function store(int $orderId, OrderShippingOption $option): void
    {
        $optionData = [
            'orders_id' => $orderId,
            'key'       => $option->getKey(),
            'value'     => $option->getValue(),
        ];
        $this->db->replace('orders_shipping_options', $optionData);
    }
    
    
    public function findByOrderId(IdType $orderId): OrderShippingOptionCollection
    {
        $options     = [];
        $optionsRows = $this->db->get_where('orders_shipping_options', 'orders_id = ' . $orderId->asInt())
            ->result_array();
        foreach ($optionsRows as $optionsRow) {
            $value = $optionsRow['value'] === 'true' ? true : $optionsRow['value'];
            $options[] = MainFactory::create('OrderShippingOption', $optionsRow['key'], $value);
        }
        
        return MainFactory::create('OrderShippingOptionCollection', $options);
    }
}